//array
let b1;
let b2;

function setup() {
	//size of the canvas
	createCanvas(500, 500);
	//creates 2 stars (variables)
	b1 = new stars(random(50, width - 50), random(50, height - 50));
	b2 = new stars(random(50, width - 50), random(50, height - 50));
}
function draw() {
	//uses the functions below to move the stars 
	b1.move();
	b2.move();
	b1.display();
	b2.display();
	//when the stars collide the background changes to different shades of blue
	//assignment operator
	let d = dist(b1.x, b1.y, b2.x, b2.y);
	//conditionals
	if (d < b1.r + b2.r) {
		background(random(130, 210), random(200, 240), random(200, 255));
		//when the stars collide one changes colour using the function
		b1.changeColor();
	}
}
class stars {
	constructor(startX, startY) {
		//makes the stars different shades of pink
		this.x = startX;
		this.y = startY;
		this.r = 50;
		this.col = color(random(220, 255), random(140, 195), random(120, 190));
		//changes the speed of the stars
		this.xSpeed = random(0.3, 5);
		this.ySpeed = random(0.3, 5);
		this.xDir = 1;
		this.yDir = 1;
	}
	//changes the colour of a star when collides with the other
	changeColor() {
		this.col = color(random(220, 255), random(140, 195), random(120, 190));
	}
	move() {
		//speed and direction of the stars
		this.x = this.x + (this.xSpeed * this.xDir);
		this.y = this.y + (this.ySpeed * this.yDir);

		if (this.x > (width - (this.r)) || this.x < (this.r)) {
			this.xDir = this.xDir * -1;
		}

		if (this.y > (height - (this.r)) || this.y < (this.r)) {
			this.yDir = this.yDir * -1;
		}
	}
	//star
	display() {
		fill(this.col);
		star(this.x, this.y, this.r, this.r * 2, 5);
	}
}
//star function
function star(x, y, radius1, radius2, npoints) {
	let angle = TWO_PI / npoints;
	let halfAngle = angle / 2.0;
	beginShape();
	//control structure (loop)
	for (let a = 0; a < TWO_PI; a += angle) {
		let sx = x + cos(a) * radius2;
		let sy = y + sin(a) * radius2;
		vertex(sx, sy);
		sx = x + cos(a + halfAngle) * radius1;
		sy = y + sin(a + halfAngle) * radius1;
		vertex(sx, sy);
	}
	endShape(CLOSE);
}